/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.common.item.explorer;

import com.minecraftabnormals.environmental.client.model.HealerPouchModel;
import com.minecraftabnormals.environmental.common.item.explorer.ExplorerArmorItem;
import com.minecraftabnormals.environmental.core.registry.EnvironmentalEffects;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="environmental")
public class HealerPouchItem
extends ExplorerArmorItem {
    private static final String NBT_TAG = "HealerPouchUses";

    public HealerPouchItem(Item.Properties properties) {
        super(EquipmentSlotType.CHEST, properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack stack, EquipmentSlotType armorSlot, A _default) {
        return HealerPouchModel.get(1.0f);
    }

    @SubscribeEvent
    public static void onEvent(LivingHurtEvent event) {
        LivingEntity entity = event.getEntityLiving();
        ItemStack stack = entity.func_184582_a(EquipmentSlotType.CHEST);
        if (stack.func_77973_b() instanceof HealerPouchItem && event.getSource().func_76346_g() instanceof LivingEntity) {
            if (entity instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)event.getEntityLiving();
                if (!player.func_184811_cZ().func_185141_a(stack.func_77973_b())) {
                    CompoundNBT tag = stack.func_196082_o();
                    int increase = ((HealerPouchItem)stack.func_77973_b()).getIncreaseForUses(tag.func_74762_e(NBT_TAG));
                    int panicSeconds = 4 * increase;
                    player.func_195064_c(new EffectInstance(Effects.field_76428_l, 20 * panicSeconds, increase > 2 ? 1 : 0));
                    player.func_195064_c(new EffectInstance((Effect)EnvironmentalEffects.PANIC.get(), 20 * panicSeconds, 0));
                    player.func_184811_cZ().func_185145_a(stack.func_77973_b(), 20 * (panicSeconds + (10 - increase * 2)));
                    ((HealerPouchItem)stack.func_77973_b()).levelUp(stack, (LivingEntity)player);
                }
            } else if (entity.field_70170_p.func_201674_k().nextInt(entity.field_70170_p.func_175659_aa().func_151525_a() + 3) != 0) {
                entity.func_70691_i(4.0f);
                entity.func_195064_c(new EffectInstance((Effect)EnvironmentalEffects.PANIC.get(), 120, 0));
            }
        }
    }

    @Override
    public String getUsesTag() {
        return NBT_TAG;
    }

    @Override
    public int[] getLevelCaps() {
        return new int[]{0, 10, 50, 100, 250};
    }
}

